/*:
 * @target MZ
 * @plugindesc v1.0 イベント／コモンイベント内の文字列を検索してコンソールに出力します。
 * @author HUMAN SIMULATE（仮）
 *
 * @command search
 * @text イベント内を検索
 * @desc 現在のマップイベント ＋ 全コモンイベントから指定の文字列を検索します（テストプレイ専用）。
 *
 * @arg keyword
 * @text 検索文字列
 * @type string
 * @default CreateSAnim(
 * @desc 検索したい文字列を指定します。例：CreateSAnim("yukino"
 */

(() => {
    const pluginName = "HS_EventSearch";

    // 汎用：コマンドリストから文字列検索
    function searchInCommandList(list, keyword, sourceInfo) {
        if (!list) return;
        for (let i = 0; i < list.length; i++) {
            const cmd = list[i];
            if (!cmd) continue;

            let text = null;

            switch (cmd.code) {
                case 401: // 文章
                case 405: // スクロール文章
                case 355: // スクリプト（1行目）
                case 655: // スクリプト（2行目以降）
                case 111: // 条件分岐（スクリプト条件など）
                    if (cmd.parameters && typeof cmd.parameters[0] === "string") {
                        text = cmd.parameters[0];
                    }
                    break;
                default:
                    // 他にも必要ならケースを足せる
                    break;
            }

            if (text && text.includes(keyword)) {
                console.log(
                    `[HS_EventSearch] HIT: ${sourceInfo} コマンドIndex:${i} code:${cmd.code}\n` +
                    `  -> ${text}`
                );
            }
        }
    }

    // 現在マップのイベントを検索
    function searchInCurrentMap(keyword) {
        if (!$dataMap) {
            console.warn("[HS_EventSearch] $dataMap がまだ読み込まれていません。マップ上で実行してください。");
            return;
        }
        console.log(`[HS_EventSearch] ===== 現在マップ(${ $dataMap.mapId || "不明" })のイベント検索開始 =====`);
        const events = $dataMap.events || [];
        for (let e of events) {
            if (!e) continue;
            const pages = e.pages || [];
            for (let p = 0; p < pages.length; p++) {
                const page = pages[p];
                const info = `MapID:${$gameMap.mapId()} EventID:${e.id}(${e.name}) Page:${p + 1}`;
                searchInCommandList(page.list, keyword, info);
            }
        }
    }

    // 全コモンイベントを検索
    function searchInCommonEvents(keyword) {
        console.log("[HS_EventSearch] ===== コモンイベント検索開始 =====");
        const list = $dataCommonEvents || [];
        for (let ce of list) {
            if (!ce) continue;
            const info = `CommonEventID:${ce.id}(${ce.name})`;
            searchInCommandList(ce.list, keyword, info);
        }
    }

    // プラグインコマンド登録
    PluginManager.registerCommand(pluginName, "search", args => {
        const keyword = String(args.keyword || "").trim();
        if (!keyword) {
            console.warn("[HS_EventSearch] 検索文字列が空です。");
            return;
        }

        console.log(`[HS_EventSearch] 検索開始 キーワード: "${keyword}"`);
        searchInCurrentMap(keyword);
        searchInCommonEvents(keyword);
        console.log("[HS_EventSearch] 検索終了。DevToolsコンソールのログを確認してください。");
    });

})();
